﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Web;

namespace AZVIC.Ei8htPOS.Utilities
{
    public class DynamicFormPost
    {
        private string actionURL;
        private const string defaultHTMLFormTemplate = "<html xmlns=\"http://www.w3.org/1999/xhtml\"><body onload=\"document.forms.dynamicform.submit()\"><noscript><p><strong>Note:</strong> Since your browser does not support Javascript, you must press the Continue button once to proceed.</p></noscript><form id=\"dynamicform\" action=\"{0}\" method=\"post\"><div>{1}</div><noscript><div><input type=\"submit\" value=\"Continue\"/></div></noscript></form></body></html>";
        private IDictionary<string, string> hiddenControls = new Dictionary<string, string>();
        private static string htmlFormTemplate = "<html xmlns=\"http://www.w3.org/1999/xhtml\"><body onload=\"document.forms.dynamicform.submit()\"><noscript><p><strong>Note:</strong> Since your browser does not support Javascript, you must press the Continue button once to proceed.</p></noscript><form id=\"dynamicform\" action=\"{0}\" method=\"post\"><div>{1}</div><noscript><div><input type=\"submit\" value=\"Continue\"/></div></noscript></form></body></html>";

        public void AddHiddenControl(string controlName, string controlValue)
        {
            this.hiddenControls.Add(controlName, controlValue);
        }

        public override string ToString()
        {
            StringBuilder builder = new StringBuilder();
            foreach (string str in this.hiddenControls.Keys)
            {
                string formVariable = this.hiddenControls[str];
                builder.AppendFormat("<input type=\"hidden\" name=\"{0}\" value=\"{1}\"/>", str, formVariable);
            }
            StringBuilder builder2 = new StringBuilder();
            builder2.AppendFormat(htmlFormTemplate, this.actionURL, builder.ToString());
            return builder2.ToString();
        }

        public void Write(Stream stream)
        {
            string str = this.ToString();
            StreamWriter writer = new StreamWriter(stream);
            writer.Write(str);
            writer.Flush();
        }

        public void Write(HttpResponse httpResponse)
        {
            this.Write(httpResponse.OutputStream);
        }

        public string ActionURL
        {
            get
            {
                return this.actionURL;
            }
            set
            {
                this.actionURL = value;
            }
        }

        public IDictionary<string, string> HiddenControls
        {
            get
            {
                return this.hiddenControls;
            }
            set
            {
                this.hiddenControls = value;
            }
        }

        public static string HTMLFormTemplate
        {
            get
            {
                return htmlFormTemplate;
            }
            set
            {
                htmlFormTemplate = value;
            }
        }
    }
}